/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.items.AbstractItemScroll;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class ItemScrollColonyTP
extends AbstractItemScroll {
    public ItemScrollColonyTP(Item.Properties properties) {
        super("scroll_tp", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, World world, ServerPlayerEntity player) {
        if (world.field_73012_v.nextInt(10) == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("minecolonies.scroll.failed" + (world.field_73012_v.nextInt(10) + 1)).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
            BlockPos pos = null;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                pos = BlockPosUtil.findAround(world, player.func_233580_cy_().func_177967_a(dir, 10), 5, 5, (predWorld, predPos) -> predWorld.func_180495_p(predPos).func_185904_a() == Material.field_151579_a && predWorld.func_180495_p(predPos.func_177984_a()).func_185904_a() == Material.field_151579_a);
                if (pos == null) continue;
                break;
            }
            if (pos != null) {
                player.func_195064_c(new EffectInstance(Effects.field_76431_k, 140));
                player.func_200619_a((ServerWorld)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            }
            SoundUtils.playSoundForPlayer(player, SoundEvents.field_187744_z, 0.4f, 1.0f);
        } else {
            this.doTeleport(player, this.getColony(itemStack), itemStack);
            SoundUtils.playSoundForPlayer(player, SoundEvents.field_190021_aL, 0.6f, 1.0f);
        }
        itemStack.func_190918_g(1);
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    protected void doTeleport(ServerPlayerEntity player, IColony colony, ItemStack stack) {
        TeleportHelper.colonyTeleport(player, colony);
    }

    public void func_219972_a(World worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 5L == 0L) {
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ParticleTypes.field_197590_A), (Entity)entity);
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ParticleTypes.field_197590_A), (ServerPlayerEntity)entity);
        }
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        TranslationTextComponent guiHint = new TranslationTextComponent("item.minecolonies.scroll_tp.tip");
        guiHint.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)guiHint);
        TranslationTextComponent colonyDesc = new TranslationTextComponent("item.minecolonies.scroll.colony.none");
        if (stack.func_196082_o().func_74764_b("desc")) {
            colonyDesc = new StringTextComponent(stack.func_196082_o().func_74779_i("desc"));
        } else {
            IColony colony = this.getColonyView(stack);
            if (colony != null) {
                colonyDesc = new StringTextComponent(colony.getName());
                stack.func_196082_o().func_74778_a("desc", colony.getName());
            }
        }
        TranslationTextComponent guiHint2 = new TranslationTextComponent("item.minecolonies.scroll.colony.tip", new Object[]{colonyDesc});
        guiHint2.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        tooltip.add((ITextComponent)guiHint2);
    }
}

